//
//  MCWindowController.h
//  MCViews
//
//  Created by mclark on Wed Aug 01 2001.
//  Copyright (c) 2001 __CompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>

@protocol MCChainedWindowControllerProtocol
- (void)setParentController:(id)aController;
- (id)parentController;
- (id)rootParentController;
@end

@class BDQualifier;
@class MCPFetchSpecification;

@interface MCWindowController : NSWindowController {

	id	_parentController;  // non-retained
	
	NSString *__originalWindowTitle;

	IBOutlet	NSProgressIndicator		*progressIndicator;
	IBOutlet	NSTextField				*progressField;

    BOOL useStandardWindowTitleBehavior; // because by default we do some crazy stuff with window titles, if you just have a standard doc based app and want standard behavior set this to YES
}

/*!
	@method propertyList
	@discussion looks in the bundle for a resource of type 'plist' with the same name as the class name, reads it as a string, then returns the property list from that string
	@result autoreleased property list
*/
+ (id)propertyList;

// posts a notification to all window controller to 'updateInterfaceFromModel' --if they respond
+ (void)allWindowControllersPerformUpdateInterfaceFromModel;

- (id)initWithParentController:(id)aController;

// parentController is not retained. It's assumed that if you set a parentController via this method or in the init, that a 'sub' controller cannot exist without it's parent.
- (void)setParentController:(id)aController;
- (id)parentController;

// Walks the parentController tree and returns the first controller whose parent returns nil or the parentController doesn't respond to 'rootParentController'
- (id)rootParentController;

// check self, then rootParentController, then document controller
- (id)getDocument;

// convenience methods
- (id)getDatabaseConnection;
- (id)getObjectContext;
- (NSArray *)objectsForEntityNamed:(NSString *)aName matchingQualifier:(BDQualifier *)qual;
- (NSArray *)objectsMatchingFetchSpecification:(MCPFetchSpecification *)fspec;


- (void)setWindowNibName:(NSString *)aName;

// run this window as a sheet
- (void)runSheetInWindow:(NSWindow *)aWindow;

// when the sheet ends - default implementation does nothing - subclasses can override
- (void)windowControllerSheetDidEnd:(NSWindow *)sheet 
    returnCode:(int)returnCode contextInfo:(void *)contextInfo;




// forwards the print message to the appropriate object. Default implementation does nothing
- (IBAction)print:(id)sender;

// Returns the view to be used when printing -- default implementation does nothing
- (id)printView;


// bug repellant:
// We need this workaround to get around the fact that frame auto save names are not saves from IB (at least with 10.1 style nibs. If this method returns YES, then the class name is used as the auto save name. The default is YES, subclassers can return NO. Called during 'init' -- does not load window.

- (BOOL)shouldAutoSetWindowFrameSaveName;


// Progress indicator functionality
- (void)setupProgressIndicatorForDisplayWithTotalIncrements:(int)incr initialMessage:(NSString *)message;
// This method does the same as above, except if flag is NO it will not increment by 1 the progress indicator
// like the above will if the message is not nil!!!!!!!
- (void)setupProgressIndicatorForDisplayWithTotalIncrements: (int)incr initialMessage: (NSString *)message
                                                  increment: (BOOL)flag;
- (void)incrementIndicatorWithMessage:(NSString *)message;
- (void)setMessage: (NSString *)message;
- (void)incrementIndicator;
- (void)setIndicatorTotalIncrements: (int)increments;
- (void)addToIncrements: (int)more_increments;
- (void)hideProgressIndicator;
- (NSProgressIndicator *)progressIndicator;
- (void)startIndeterminateProgressWithMessage:(NSString *)aMessage;

- (void)performSelectorNotification:(NSNotification *)notif;

- (void)updateWindowTitle;
- (NSString *)originalWindowTitle;
- (void)setOriginalWindowTitle:(NSString *)anOriginalWindowTitle;


- (void)setupWindowTitleButtonWithImage:(NSImage *)image target:(id)target action:(SEL)action;

- (BOOL)windowControllerShouldClose;


- (BOOL)useStandardWindowTitleBehavior;
- (void)setUseStandardWindowTitleBehavior:(BOOL)flag;
@end


@interface NSWindowController (MCSheet)
- (void)runSimpleInfoSheetWithTitle:(NSString *)aTitle message:(NSString *)aMessage;
@end

@interface NSWindow (MCSheet)
- (void)runSimpleInfoSheetWithTitle:(NSString *)aTitle message:(NSString *)aMessage;
@end

@interface NSWindowController (MCDisplayProperties)
- (void)encodeDisplayPropertiesIntoDictionary:(NSMutableDictionary *)dict;
- (void)decodeDisplayPropertiesFromDictionary:(NSDictionary *)dict;
@end

@interface NSWindowController (Private)
- (void)_windowWillClose:(NSNotification *)notif;
@end

@interface NSWindowController (MCLocalize)

/*!
 If there is a localization strings file with the same name as the classname, then the top level objects are passed to MCLocalizer
Subclassers can override this method if they do not want localization to occur or if they want to do their own thing
 */
- (void)autoLocalize;

@end

@interface NSWindowController (MCPrepareForAppFlavor)
/*!
 Used by subclassers for any kind of version (solo, normal, pro) related adds or removes. Called during awakeFromNib and before autoLocalize. Default implementation does nothing.
 Added by AJ 2009-10-17.
 */
- (void)prepareForAppFlavor;
@end
